<!-- sidebar.php -->
<style>
    .sidebar {
        width: 250px;
        background-color: #343a40;
        min-height: 100vh;
        color: #fff;
        padding-top: 20px;
        position: fixed;
    }
    .sidebar .menu-header {
        padding: 10px 20px;
        font-size: 0.85rem;
        color: #adb5bd;
        cursor: pointer;
    }
    .sidebar a {
        color: #fff;
        display: block;
        padding: 10px 20px;
        text-decoration: none;
    }
    .sidebar a:hover {
        background-color: #495057;
    }
    .submenu {
        display: none;
        background-color: #3f454d;
    }
    .submenu a {
        padding-left: 40px;
        font-size: 0.9rem;
    }
</style>

<div class="sidebar">
    <h4 class="text-center text-white">🛠️ Admin Panel</h4>

    <a href="dashboard.php">📊 Dashboard</a>

    <div class="menu-header" onclick="toggleMenu('membersMenu')">👥 Members ▾</div>
    <div id="membersMenu" class="submenu">
        <a href="add_member.php">➕ Add Member</a>
        <a href="manage_members.php">👤 Manage Members</a>
        <a href="kyc_verification.php">📝 KYC Verification</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('treeMenu')">🌳 Tree ▾</div>
    <div id="treeMenu" class="submenu">
        <a href="view_tree.php">🌲 View Tree</a>
        <a href="direct_referrals.php">🔗 Direct Referrals</a>
        <a href="team_levels.php">📊 Team Levels</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('incomeMenu')">💰 Income ▾</div>
    <div id="incomeMenu" class="submenu">
        <a href="income_level.php">💸 Level Income</a>
        <a href="income_direct.php">📥 Direct Income</a>
        <a href="income_binary.php">⚖️ Binary Income</a>
        <a href="income_daily.php">📅 Daily ROI</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('withdrawMenu')">💸 Withdrawals ▾</div>
    <div id="withdrawMenu" class="submenu">
        <a href="withdraw_requests.php">🧾 Withdrawal Requests</a>
        <a href="withdraw_history.php">📜 Withdrawal History</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('planMenu')">📦 Plans ▾</div>
    <div id="planMenu" class="submenu">
        <a href="add_plan.php">➕ Add Plan</a>
        <a href="manage_plans.php">📋 Manage Plans</a>
        <a href="roi_settings.php">⚙️ ROI Settings</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('reportMenu')">📁 Reports ▾</div>
    <div id="reportMenu" class="submenu">
        <a href="report_members.php">👥 Member Report</a>
        <a href="report_income.php">📈 Income Report</a>
        <a href="report_withdrawals.php">💳 Withdrawal Report</a>
        <a href="report_login.php">📍 Login History</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('notifyMenu')">📤 Communication ▾</div>
    <div id="notifyMenu" class="submenu">
        <a href="send_notification.php">📨 Send Notification</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('settingMenu')">⚙️ Settings ▾</div>
    <div id="settingMenu" class="submenu">
        <a href="site_settings.php">🌐 Site Settings</a>
        <a href="payment_settings.php">💳 Payment Gateway</a>
        <a href="withdrawal_settings.php">⚖️ Withdrawal Rules</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('adminMenu')">🔐 Admin ▾</div>
    <div id="adminMenu" class="submenu">
        <a href="create_admin.php">➕ Create Admin</a>
        <a href="manage_admins.php">👤 Manage Admins</a>
    </div>

    <a href="logout.php" class="text-danger mt-3">🚪 Logout</a>
</div>

<!-- Sidebar Toggle Script -->
<script>
    function toggleMenu(id) {
        const menu = document.getElementById(id);
        menu.style.display = menu.style.display === 'block' ? 'none' : 'block';
    }
</script>
