<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}
$adminEmail = htmlspecialchars($_SESSION['admin_email'] ?? 'Admin');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { min-height: 100vh; display: flex; }
        .sidebar {
            width: 250px; background-color: #343a40; color: #fff; padding-top: 20px;
        }
        .sidebar .menu-header {
            padding: 10px 20px; font-size: 0.85rem; color: #adb5bd; cursor: pointer;
        }
        .sidebar a {
            color: #fff; display: block; padding: 10px 20px; text-decoration: none;
        }
        .sidebar a:hover, .menu-header:hover {
            background-color: #495057;
        }
        .submenu { display: none; background-color: #3f454d; }
        .submenu a { padding-left: 40px; font-size: 0.9rem; }
        .main-content { flex: 1; padding: 20px; background-color: #f8f9fa; }
    </style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar">
    <h4 class="text-center text-white">Admin Panel</h4>
    <a href="dashboard.php">📊 Dashboard</a>
    <a href="add_plan.php">➕ Add Plan</a>
    <!-- और बाकी links -->
    <a href="logout.php" class="text-danger mt-3">🚪 Logout</a>
</div>

<!-- Main Content -->
<div class="main-content">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3>Welcome to MLM Admin Dashboard</h3>
        <div><strong>Logged in as:</strong> <?= $adminEmail ?></div>
    </div>

    <?php
    // Include the actual content page from variable
    if (isset($content_page) && file_exists($content_page)) {
        include $content_page;
    } else {
        echo "<p class='text-muted'>Content not found.</p>";
    }
    ?>
</div>

<script>
    function toggleMenu(id) {
        let el = document.getElementById(id);
        el.style.display = el.style.display === 'block' ? 'none' : 'block';
    }
</script>
</body>
</html>
