<?php
session_start();
if (!isset($_SESSION['user_logged_in'])) {
    header("Location: login.php");
    exit;
}

define('IS_USER_LAYOUT', true);
$user_name = $_SESSION['user_name'] ?? 'User';
$page = $_GET['page'] ?? 'home';
?>

<!DOCTYPE html>
<html>
<head>
    <title>User Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            display: flex;
        }
        .sidebar {
            width: 220px;
            background-color: #343a40;
            color: white;
            height: 100vh;
            padding-top: 20px;
            position: fixed;
        }
        .sidebar a {
            color: white;
            display: block;
            padding: 12px 20px;
            text-decoration: none;
        }
        .sidebar a:hover {
            background-color: #495057;
        }
        .main-content {
            margin-left: 220px;
            padding: 20px;
            width: 100%;
            background: #f8f9fa;
        }
    </style>
</head>
<body>

<div class="sidebar">
    <h4 class="text-center">👤 <?= htmlspecialchars($user_name) ?></h4>
    <a href="dashboard.php?page=home">🏠 Home</a>
    <a href="dashboard.php?page=plans">📦 Buy Plan</a>
    <a href="dashboard.php?page=my_plans">✅ My Plans</a>
    <a href="dashboard.php?page=wallet">💰 Wallet</a>
    <a href="logout.php">🚪 Logout</a>
</div>

<div class="main-content">
    <?php
    $allowed = ['home', 'plans', 'my_plans', 'wallet'];
    $filepath = __DIR__ . "/pages/$page.php";
    if (in_array($page, $allowed) && file_exists($filepath)) {
        include $filepath;
    } else {
        echo "<p class='text-muted'>Select an option from sidebar.</p>";
    }
    ?>
</div>

</body>
</html>
