<?php
require_once 'config/db.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $sponsor_id = trim($_POST['sponsor_id']);
    $name = trim($_POST['name']);
    $father_name = trim($_POST['father_name']);
    $dob = $_POST['dob'];
    $phone = trim($_POST['phone']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $joining_date = date('Y-m-d');
    $aadhaar = trim($_POST['aadhaar']);
    $pan = trim($_POST['pan']);
    $address = trim($_POST['address']);
    $locality = trim($_POST['locality']);
    $city = trim($_POST['city']);
    $state = trim($_POST['state']);
    $country = trim($_POST['country']);
    $bank_ac = trim($_POST['bank_ac']);
    $bank_name = trim($_POST['bank_name']);
    $branch = trim($_POST['branch']);
    $ifsc = trim($_POST['ifsc']);

    // File uploads
    $aadhaar_file = $_FILES['aadhaar_file']['name'];
    $pan_file = $_FILES['pan_file']['name'];
    $photo = $_FILES['photo']['name'];

    // Password check
    if ($password !== $confirm_password) {
        $message = "❌ Passwords do not match.";
    } else {
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);

        // Check if first user
        $check = $pdo->query("SELECT COUNT(*) AS total FROM users");
        $totalUsers = $check->fetch()['total'];

        if ($totalUsers == 0) {
            $user_id = 'DUST20250000';
            $sponsor_id = '';
            $name = 'ADMIN';
        } else {
            $user_id = 'DUST' . date('Y') . substr($aadhaar, -4);
        }

        $upload_dir = "uploads/";
        move_uploaded_file($_FILES['aadhaar_file']['tmp_name'], $upload_dir . $aadhaar_file);
        move_uploaded_file($_FILES['pan_file']['tmp_name'], $upload_dir . $pan_file);
        move_uploaded_file($_FILES['photo']['tmp_name'], $upload_dir . $photo);

        $stmt = $pdo->prepare("INSERT INTO users (
            user_id, sponsor_id, name, father_name, dob, phone, email, password, joining_date,
            aadhaar, pan, address, locality, city, state, country, account_no, bank_name, branch, ifsc,
            aadhaar_file, pan_file, photo
        ) VALUES (
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
        )");

        $done = $stmt->execute([
            $user_id, $sponsor_id, $name, $father_name, $dob, $phone, $email, $hashed_password, $joining_date,
            $aadhaar, $pan, $address, $locality, $city, $state, $country,
            $bank_ac, $bank_name, $branch, $ifsc,
            $aadhaar_file, $pan_file, $photo
        ]);

        $message = $done ? "✅ Registered! Your ID: $user_id" : "❌ Failed to register.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Registration</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-4">
    <div class="card mx-auto" style="max-width: 850px;">
        <div class="card-header bg-primary text-white">
            <h4>User Registration</h4>
        </div>
        <div class="card-body">
            <?php if ($message): ?>
                <div class="alert alert-info"><?= $message ?></div>
            <?php endif; ?>
            <form method="POST" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label>Sponsor ID</label>
                        <input type="text" name="sponsor_id" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Full Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Father's Name</label>
                        <input type="text" name="father_name" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>DOB</label>
                        <input type="date" name="dob" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Phone</label>
                        <input type="tel" name="phone" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Email</label>
                        <input type="email" name="email" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Password</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Confirm Password</label>
                        <input type="password" name="confirm_password" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Aadhaar No.</label>
                        <input type="text" name="aadhaar" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>PAN No.</label>
                        <input type="text" name="pan" class="form-control">
                    </div>
                    <div class="col-md-12 mb-3">
                        <label>Address</label>
                        <input type="text" name="address" class="form-control">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label>Locality</label>
                        <input type="text" name="locality" class="form-control">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label>City</label>
                        <input type="text" name="city" class="form-control">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label>State</label>
                        <input type="text" name="state" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Country</label>
                        <input type="text" name="country" class="form-control" value="India">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Bank Account No.</label>
                        <input type="text" name="bank_ac" class="form-control">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label>Bank Name</label>
                        <input type="text" name="bank_name" class="form-control">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label>Branch</label>
                        <input type="text" name="branch" class="form-control">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label>IFSC Code</label>
                        <input type="text" name="ifsc" class="form-control">
                    </div>
                    <div class="col-md-4 mb-3">
                        <label>Aadhaar File</label>
                        <input type="file" name="aadhaar_file" class="form-control" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label>PAN File</label>
                        <input type="file" name="pan_file" class="form-control" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label>Photo</label>
                        <input type="file" name="photo" class="form-control" required>
                    </div>
                    <div class="col-md-12 mb-3">
                        <label><input type="checkbox" required> I agree to the Terms & Conditions</label>
                    </div>
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-success w-100">Register Now</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
</body>
</html>
