<?php
require_once '../config/db.php'; // DB connection file

$today = date('Y-m-d');
$inserted = 0;

// Fetch active user plans
$sql = "SELECT up.*, p.plan_name FROM user_plans up
        JOIN plans p ON up.plan_id = p.id
        WHERE up.status = 'Active'";
$stmt = $pdo->query($sql);

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $user_id = $row['user_id'];
    $plan_id = $row['plan_id'];
    $amount = $row['amount'];
    $roi_percent = $row['roi_percent'];
    $duration_days = $row['duration_days'];
    $days_paid = $row['days_paid'];
    $start_date = $row['start_date'];

    // Check if ROI complete
    if ($days_paid >= $duration_days) {
        $pdo->prepare("UPDATE user_plans SET status = 'Completed' WHERE id = ?")->execute([$row['id']]);
        continue;
    }

    // Calculate ROI
    $roi_amount = round($amount * $roi_percent / 100, 2);

    // Insert into roi_income_log
    $stmt2 = $pdo->prepare("INSERT INTO roi_income_log (user_id, plan_id, amount, date, note) VALUES (?, ?, ?, ?, ?)");
    $stmt2->execute([$user_id, $plan_id, $roi_amount, $today, "Daily ROI"]);

    // Update days_paid
    $stmt3 = $pdo->prepare("UPDATE user_plans SET days_paid = days_paid + 1 WHERE id = ?");
    $stmt3->execute([$row['id']]);

    $inserted++;
}

echo "✅ ROI generation complete. Total entries added: $inserted";
