<?php
if (!defined('IS_ADMIN_LAYOUT')) {
    die("Access Denied");
}

require_once '../config/db.php';
$message = '';

// ROI update logic
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_roi'])) {
    $id = intval($_POST['plan_id']);
    $roi = floatval($_POST['roi_percent']);
    $duration = intval($_POST['duration_days']);

    $stmt = $pdo->prepare("UPDATE plans SET roi_percent = ?, duration_days = ? WHERE id = ?");
    if ($stmt->execute([$roi, $duration, $id])) {
        $message = "✅ ROI updated successfully.";
    } else {
        $message = "❌ Failed to update ROI.";
    }
}

// Fetch all plans
$plans = $pdo->query("SELECT * FROM plans ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="card">
    <div class="card-header bg-info text-white">
        <h4>📦 ROI Settings</h4>
    </div>
    <div class="card-body">
        <?php if (!empty($message)): ?>
            <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>

        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Plan Name</th>
                    <th>Amount (₹)</th>
                    <th>ROI %</th>
                    <th>Duration (Days)</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($plans as $index => $plan): ?>
                    <tr>
                        <form method="POST">
                            <td><?= $index + 1 ?></td>
                            <td><?= htmlspecialchars($plan['plan_name']) ?></td>
                            <td><?= number_format($plan['amount'], 2) ?></td>
                            <td style="width: 100px;">
                                <input type="number" step="0.01" name="roi_percent" value="<?= $plan['roi_percent'] ?>" class="form-control" required>
                            </td>
                            <td style="width: 120px;">
                                <input type="number" name="duration_days" value="<?= $plan['duration_days'] ?>" class="form-control" required>
                            </td>
                            <td>
                                <input type="hidden" name="plan_id" value="<?= $plan['id'] ?>">
                                <button type="submit" name="update_roi" class="btn btn-success btn-sm">Update</button>
                            </td>
                        </form>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
