<?php
if (!defined('IS_ADMIN_LAYOUT')) {
    die("Access denied.");
}
require_once '../config/db.php';

// Delete functionality
if (isset($_GET['delete_id'])) {
    $deleteId = intval($_GET['delete_id']);
    $stmt = $pdo->prepare("DELETE FROM plans WHERE id = ?");
    $stmt->execute([$deleteId]);
    echo "<div class='alert alert-warning'>Plan deleted successfully.</div>";
}

// Fetch all plans
$stmt = $pdo->query("SELECT * FROM plans ORDER BY id DESC");
$plans = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="card">
    <div class="card-header bg-secondary text-white">
        <h5>📋 Manage Plans</h5>
    </div>
    <div class="card-body">
        <?php if (count($plans) === 0): ?>
            <p class="text-muted">No plans found.</p>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-bordered table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Plan Name</th>
                            <th>Amount (₹)</th>
                            <th>BV</th>
                            <th>Direct Income</th>
                            <th>Binary Income</th>
                            <th>ROI %</th>
                            <th>Duration (days)</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($plans as $plan): ?>
                            <tr>
                                <td><?= $plan['id'] ?></td>
                                <td><?= htmlspecialchars($plan['plan_name']) ?></td>
                                <td>₹<?= number_format($plan['amount'], 2) ?></td>
                                <td><?= $plan['bv'] ?></td>
                                <td>₹<?= number_format($plan['direct_income'], 2) ?></td>
                                <td>₹<?= number_format($plan['binary_income'], 2) ?></td>
                                <td><?= $plan['roi_percent'] ?>%</td>
                                <td><?= $plan['duration_days'] ?> days</td>
                                <td>
                                    <a href="dashboard.php?page=edit_plan&id=<?= $plan['id'] ?>" class="btn btn-sm btn-primary">Edit</a>
                                    <a href="dashboard.php?page=manage_plans&delete_id=<?= $plan['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this plan?');">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>
