<?php
if (!defined('IS_ADMIN_LAYOUT')) {
    exit('Direct access not allowed');
}

// Include database connection if not included already (optional if included in dashboard.php)
// require_once __DIR__ . '/../config/db.php';

// Pagination settings (optional)
$limit = 20;
$page_num = isset($_GET['p']) ? max(1, (int)$_GET['p']) : 1;
$offset = ($page_num - 1) * $limit;

// Total users count for pagination
$totalStmt = $pdo->query("SELECT COUNT(*) FROM users");
$totalUsers = $totalStmt->fetchColumn();
$totalPages = ceil($totalUsers / $limit);

// Fetch users
$stmt = $pdo->prepare("SELECT user_id, sponsor_id, name, father_name, phone, email, joining_date FROM users ORDER BY joining_date DESC LIMIT :limit OFFSET :offset");
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<h4>Manage Members (Total: <?= $totalUsers ?>)</h4>

<?php if (empty($users)): ?>
    <p>No members found.</p>
<?php else: ?>
    <table class="table table-bordered table-hover">
        <thead class="table-primary">
            <tr>
                <th>#</th>
                <th>User ID</th>
                <th>Sponsor ID</th>
                <th>Name</th>
                <th>Father's Name</th>
                <th>Phone</th>
                <th>Email</th>
                <th>Joining Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $index => $user): ?>
                <tr>
                    <td><?= $offset + $index + 1 ?></td>
                    <td><?= htmlspecialchars($user['user_id']) ?></td>
                    <td><?= htmlspecialchars($user['sponsor_id']) ?></td>
                    <td><?= htmlspecialchars($user['name']) ?></td>
                    <td><?= htmlspecialchars($user['father_name']) ?></td>
                    <td><?= htmlspecialchars($user['phone']) ?></td>
                    <td><?= htmlspecialchars($user['email']) ?></td>
                    <td><?= date('d M Y', strtotime($user['joining_date'])) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Pagination -->
    <nav>
        <ul class="pagination">
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?= ($i === $page_num) ? 'active' : '' ?>">
                    <a class="page-link" href="?page=manage_members&p=<?= $i ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>
        </ul>
    </nav>
<?php endif; ?>
