<?php
if (!defined('IS_ADMIN_LAYOUT')) {
    die("Access denied.");
}

require_once '../config/db.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid Plan ID.");
}

$id = intval($_GET['id']);
$stmt = $pdo->prepare("SELECT * FROM plans WHERE id = ?");
$stmt->execute([$id]);
$plan = $stmt->fetch();

if (!$plan) {
    die("Plan not found.");
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $plan_name = trim($_POST['plan_name']);
    $amount = floatval($_POST['amount']);
    $bv = intval($_POST['bv']);
    $direct_income = floatval($_POST['direct_income']);
    $binary_income = floatval($_POST['binary_income']);
    $roi_percent = isset($_POST['roi_percent']) ? floatval($_POST['roi_percent']) : 0;
    $duration_days = isset($_POST['duration_days']) ? intval($_POST['duration_days']) : 0;

    $update = $pdo->prepare("UPDATE plans SET plan_name=?, amount=?, bv=?, direct_income=?, binary_income=?, roi_percent=?, duration_days=? WHERE id=?");
    if ($update->execute([$plan_name, $amount, $bv, $direct_income, $binary_income, $roi_percent, $duration_days, $id])) {
        $message = "✅ Plan updated successfully!";
        // Refresh updated data
        $stmt->execute([$id]);
        $plan = $stmt->fetch();
    } else {
        $message = "❌ Failed to update plan.";
    }
}
?>

<div class="card mx-auto" style="max-width: 700px;">
    <div class="card-header bg-info text-white">
        <h4>Edit Plan</h4>
    </div>
    <div class="card-body">
        <?php if (!empty($message)): ?>
            <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="mb-3">
                <label>Plan Name</label>
                <input type="text" name="plan_name" value="<?= htmlspecialchars($plan['plan_name']) ?>" required class="form-control">
            </div>
            <div class="mb-3">
                <label>Amount (₹)</label>
                <input type="number" step="0.01" name="amount" value="<?= $plan['amount'] ?>" required class="form-control">
            </div>
            <div class="mb-3">
                <label>BV (Business Volume)</label>
                <input type="number" name="bv" value="<?= $plan['bv'] ?>" required class="form-control">
            </div>
            <div class="mb-3">
                <label>Direct Income (₹)</label>
                <input type="number" step="0.01" name="direct_income" value="<?= $plan['direct_income'] ?>" required class="form-control">
            </div>
            <div class="mb-3">
                <label>Binary Income Per Pair (₹)</label>
                <input type="number" step="0.01" name="binary_income" value="<?= $plan['binary_income'] ?>" required class="form-control">
            </div>
            <div class="mb-3">
                <label>ROI % (optional)</label>
                <input type="number" name="roi_percent" step="0.01" value="<?= $plan['roi_percent'] ?>" class="form-control">
            </div>
            <div class="mb-3">
                <label>ROI Duration Days (optional)</label>
                <input type="number" name="duration_days" value="<?= $plan['duration_days'] ?>" class="form-control">
            </div>
            <button class="btn btn-primary" type="submit">Update Plan</button>
            <a href="dashboard.php?page=manage_plans" class="btn btn-secondary float-end">Back</a>
        </form>
    </div>
</div>
