<?php
session_start();
require_once '../config/db.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $plan_name = $_POST['plan_name'];
    $amount = $_POST['amount'];
    $bv = $_POST['bv'];
    $direct_income = $_POST['direct_income'];
    $binary_income = $_POST['binary_income'];
    $roi_percent = $_POST['roi_percent'];
    $duration_days = $_POST['duration_days'];

    $stmt = $pdo->prepare("INSERT INTO plans (plan_name, amount, bv, direct_income, binary_income, roi_percent, duration_days) VALUES (?, ?, ?, ?, ?, ?, ?)");
    if ($stmt->execute([$plan_name, $amount, $bv, $direct_income, $binary_income, $roi_percent, $duration_days])) {
        $message = "✅ Plan added successfully!";
    } else {
        $message = "❌ Failed to add plan.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add New Plan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-4">
    <div class="card mx-auto" style="max-width: 600px;">
        <div class="card-header bg-primary text-white">
            <h4>Add New Plan</h4>
        </div>
        <div class="card-body">
            <?php if ($message): ?>
                <div class="alert alert-info"><?= $message ?></div>
            <?php endif; ?>
            <form method="POST">
                <div class="mb-3">
                    <label>Plan Name</label>
                    <input type="text" name="plan_name" required class="form-control">
                </div>
                <div class="mb-3">
                    <label>Amount (₹)</label>
                    <input type="number" name="amount" required class="form-control">
                </div>
                <div class="mb-3">
                    <label>BV (Business Volume)</label>
                    <input type="number" name="bv" required class="form-control">
                </div>
                <div class="mb-3">
                    <label>Direct Income (₹)</label>
                    <input type="number" name="direct_income" required class="form-control">
                </div>
                <div class="mb-3">
                    <label>Binary Income Per Pair (₹)</label>
                    <input type="number" name="binary_income" required class="form-control">
                </div>
                <div class="mb-3">
                    <label>ROI % (optional)</label>
                    <input type="number" name="roi_percent" step="0.01" class="form-control">
                </div>
                <div class="mb-3">
                    <label>ROI Duration Days (optional)</label>
                    <input type="number" name="duration_days" class="form-control">
                </div>
                <button class="btn btn-success" type="submit">Add Plan</button>
                <a href="manage_plans.php" class="btn btn-secondary float-end">View Plans</a>
            </form>
        </div>
    </div>
</div>
</body>
</html>
