<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

$adminEmail = htmlspecialchars($_SESSION['admin_email'] ?? 'Admin');
$page = $_GET['page'] ?? 'home';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            display: flex;
            font-family: Arial, sans-serif;
        }
        .sidebar {
            width: 250px;
            background-color: #343a40;
            color: #fff;
            padding-top: 20px;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
        }
        .sidebar h4 {
            margin-bottom: 20px;
        }
        .sidebar .menu-header {
            padding: 10px 20px;
            font-size: 0.85rem;
            color: #adb5bd;
            cursor: pointer;
        }
        .sidebar a {
            color: #fff;
            display: block;
            padding: 10px 20px;
            text-decoration: none;
        }
        .sidebar a:hover, .menu-header:hover {
            background-color: #495057;
        }
        .submenu {
            display: none;
            background-color: #3f454d;
        }
        .submenu a {
            padding-left: 40px;
            font-size: 0.9rem;
        }
        .main-content {
            margin-left: 250px;
            padding: 20px;
            width: calc(100% - 250px);
            background-color: #f8f9fa;
        }
        .logout-btn {
            padding: 10px 20px;
            color: #dc3545;
            display: block;
            text-decoration: none;
            font-weight: bold;
        }
        .logout-btn:hover {
            background-color: #661616;
            color: white;
        }
    </style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar">
    <h4 class="text-center">Admin Panel</h4>
    <a href="dashboard.php">📊 Dashboard</a>

    <div class="menu-header" onclick="toggleMenu('membersMenu')">👥 Members ▾</div>
    <div id="membersMenu" class="submenu">
        <a href="dashboard.php?page=add_member">➕ Add Member</a>
        <a href="dashboard.php?page=manage_members">👤 Manage Members</a>
        <a href="dashboard.php?page=kyc_verification">📝 KYC Verification</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('treeMenu')">🌳 Tree ▾</div>
    <div id="treeMenu" class="submenu">
        <a href="dashboard.php?page=view_tree">🌲 View Tree</a>
        <a href="dashboard.php?page=direct_referrals">🔗 Direct Referrals</a>
        <a href="dashboard.php?page=team_levels">📊 Team Levels</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('incomeMenu')">💰 Income ▾</div>
    <div id="incomeMenu" class="submenu">
        <a href="dashboard.php?page=income_level">💸 Level Income</a>
        <a href="dashboard.php?page=income_direct">📥 Direct Income</a>
        <a href="dashboard.php?page=income_binary">⚖️ Binary Income</a>
        <a href="dashboard.php?page=income_daily">📅 Daily ROI</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('withdrawMenu')">💸 Withdrawals ▾</div>
    <div id="withdrawMenu" class="submenu">
        <a href="dashboard.php?page=withdraw_requests">🧾 Withdrawal Requests</a>
        <a href="dashboard.php?page=withdraw_history">📜 Withdrawal History</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('planMenu')">📦 Plans ▾</div>
    <div id="planMenu" class="submenu">
        <a href="dashboard.php?page=add_plan">➕ Add Plan</a>
        <a href="dashboard.php?page=manage_plans">📋 Manage Plans</a>
        <a href="dashboard.php?page=roi_settings">⚙️ ROI Settings</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('reportMenu')">📁 Reports ▾</div>
    <div id="reportMenu" class="submenu">
        <a href="dashboard.php?page=report_members">👥 Member Report</a>
        <a href="dashboard.php?page=report_income">📈 Income Report</a>
        <a href="dashboard.php?page=report_withdrawals">💳 Withdrawal Report</a>
        <a href="dashboard.php?page=report_login">📍 Login History</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('notifyMenu')">📤 Communication ▾</div>
    <div id="notifyMenu" class="submenu">
        <a href="dashboard.php?page=send_notification">📨 Send Notification</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('settingMenu')">⚙️ Settings ▾</div>
    <div id="settingMenu" class="submenu">
        <a href="dashboard.php?page=site_settings">🌐 Site Settings</a>
        <a href="dashboard.php?page=payment_settings">💳 Payment Gateway</a>
        <a href="dashboard.php?page=withdrawal_settings">⚖️ Withdrawal Rules</a>
    </div>

    <div class="menu-header" onclick="toggleMenu('adminMenu')">🔐 Admin ▾</div>
    <div id="adminMenu" class="submenu">
        <a href="dashboard.php?page=create_admin">➕ Create Admin</a>
        <a href="dashboard.php?page=manage_admins">👤 Manage Admins</a>
    </div>

    <a href="logout.php" class="logout-btn">🚪 Logout</a>
</div>

<!-- Main Content -->
<div class="main-content">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3>Welcome to MLM Admin Dashboard</h3>
        <div><strong>Logged in as:</strong> <?= $adminEmail ?></div>
    </div>

    <?php
    $allowed_pages = [
        'add_member', 'manage_members', 'kyc_verification',
        'view_tree', 'direct_referrals', 'team_levels',
        'income_level', 'income_direct', 'income_binary', 'income_daily',
        'withdraw_requests', 'withdraw_history',
        'add_plan', 'manage_plans', 'roi_settings',
        'report_members', 'report_income', 'report_withdrawals', 'report_login',
        'send_notification', 'site_settings', 'payment_settings', 'withdrawal_settings',
        'create_admin', 'manage_admins', 'edit_plan' // ✅ include edit_plan
    ];

    $filepath = __DIR__ . "/pages/$page.php";
    if (in_array($page, $allowed_pages) && file_exists($filepath)) {
        define('IS_ADMIN_LAYOUT', true); // ✅ define only if allowed
        include $filepath;
    } else {
        echo "<p class='text-muted'>Please select a menu option from the left.</p>";
    }
    ?>
</div>

<script>
    function toggleMenu(id) {
        const menu = document.getElementById(id);
        menu.style.display = (menu.style.display === 'block') ? 'none' : 'block';
    }
</script>

</body>
</html>
