<?php
session_start();
require_once '../config/db.php';

// ✅ Optional: Allow only super-admin if needed
// if (!isset($_SESSION['admin_logged_in'])) {
//     header("Location: login.php");
//     exit;
// }

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "❌ Invalid email format!";
    } elseif (strlen($password) < 6) {
        $message = "❌ Password must be at least 6 characters!";
    } else {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        // Check if email already exists
        $stmt = $pdo->prepare("SELECT id FROM admins WHERE email = ?");
        $stmt->execute([$email]);
        if ($stmt->fetch()) {
            $message = "❌ Email already exists!";
        } else {
            // Insert new admin
            $stmt = $pdo->prepare("INSERT INTO admins (email, password) VALUES (?, ?)");
            if ($stmt->execute([$email, $hashed_password])) {
                $message = "✅ Admin created successfully!";
            } else {
                $message = "❌ Failed to create admin.";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="card mx-auto" style="max-width: 500px;">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Create New Admin</h5>
        </div>
        <div class="card-body">
            <?php if ($message): ?>
                <div class="alert alert-info"><?= $message ?></div>
            <?php endif; ?>
            <form method="post" autocomplete="off">
                <div class="mb-3">
                    <label>Email Address</label>
                    <input type="email" name="email" required class="form-control" placeholder="Enter admin email">
                </div>
                <div class="mb-3">
                    <label>Password</label>
                    <input type="password" name="password" required class="form-control" placeholder="Enter password (min 6 characters)">
                </div>
                <button type="submit" class="btn btn-success">Create Admin</button>
                <a href="dashboard.php" class="btn btn-secondary float-end">Back</a>
            </form>
        </div>
    </div>
</div>
</body>
</html>
