<?php
if (!defined('IS_ADMIN_LAYOUT')) {
    die("Access denied.");
}

require_once '../config/db.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $plan_name = trim($_POST['plan_name']);
    $amount = floatval($_POST['amount']);
    $bv = intval($_POST['bv']);
    $direct_income = floatval($_POST['direct_income']);
    $binary_income = floatval($_POST['binary_income']);
    $roi_percent = isset($_POST['roi_percent']) ? floatval($_POST['roi_percent']) : 0;
    $duration_days = isset($_POST['duration_days']) ? intval($_POST['duration_days']) : 0;

    $stmt = $pdo->prepare("INSERT INTO plans (plan_name, amount, bv, direct_income, binary_income, roi_percent, duration_days) VALUES (?, ?, ?, ?, ?, ?, ?)");
    if ($stmt->execute([$plan_name, $amount, $bv, $direct_income, $binary_income, $roi_percent, $duration_days])) {
        $message = "✅ Plan added successfully!";
    } else {
        $message = "❌ Failed to add plan.";
    }
}
?>

<div class="card mx-auto" style="max-width: 700px;">
    <div class="card-header bg-primary text-white">
        <h4>Add New Plan</h4>
    </div>
    <div class="card-body">
        <?php if (!empty($message)): ?>
            <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
        <form method="POST" autocomplete="off">
            <div class="mb-3">
                <label>Plan Name</label>
                <input type="text" name="plan_name" required class="form-control">
            </div>
            <div class="mb-3">
                <label>Amount (₹)</label>
                <input type="number" step="0.01" name="amount" required class="form-control">
            </div>
            <div class="mb-3">
                <label>BV (Business Volume)</label>
                <input type="number" name="bv" required class="form-control">
            </div>
            <div class="mb-3">
                <label>Direct Income (₹)</label>
                <input type="number" step="0.01" name="direct_income" required class="form-control">
            </div>
            <div class="mb-3">
                <label>Binary Income Per Pair (₹)</label>
                <input type="number" step="0.01" name="binary_income" required class="form-control">
            </div>
            <div class="mb-3">
                <label>ROI % (optional)</label>
                <input type="number" name="roi_percent" step="0.01" class="form-control">
            </div>
            <div class="mb-3">
                <label>ROI Duration Days (optional)</label>
                <input type="number" name="duration_days" class="form-control">
            </div>
            <button class="btn btn-success" type="submit">Add Plan</button>
            <a href="dashboard.php?page=manage_plans" class="btn btn-secondary float-end">View Plans</a>
        </form>
    </div>
</div>
